from Prophet.Executable import _Multiname


# Since XFce utilities' executable names are self-distinctive and these
# utilities can be used independently from main package, we basically don't
# need to perform specific scan - standard algorithm is sufficient.


class xfclock (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFclock'
		self.comment = 'XFce clock/calendar'
		self.keywords = ['standard', 'X11', 'XFce', 'clock', 'calendar', 'utility']
		self._executables = ['xfclock']


class xfdiff (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFdiff'
		self.comment = 'XFce diff frontend'
		self.keywords = ['standard', 'X11', 'XFce', 'diff', 'frontend',
			'utility', 'develop']
		self._executables = ['xfdiff']


class xfglob (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFglob'
		self.comment = 'XFce find file'
		self.keywords = ['standard', 'X11', 'XFce', 'find', 'frontend',
			'utility', 'search']
		self._executables = ['xfglob']


class xfhelp (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFhelp'
		self.comment = 'XFce manual browser'
		self.keywords = ['standard', 'X11', 'XFce', 'help', 'manual', 'browse']
		self._executables = ['xfhelp']


class xflock (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFlock'
		self.comment = 'XFce screen locker'
		self.keywords = ['standard', 'X11', 'XFce', 'screen', 'lock', 'utility']
		self._executables = ['xflock']


# FIXME : what to mention this one for???
class xfmountdev (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFmountdev'
		self.comment = 'File system mount utility for XFce'
		self.keywords = ['standard', 'X11', 'XFce', 'mount', 'FS', 'file',
			'system', 'utility']
		self._executables = ['xfmountdev']
		self.interactive = 0


class xfrun (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFrun'
		self.comment = 'XFce program launcher'
		self.keywords = ['standard', 'X11', 'XFce', 'program', 'run', 'launch', 'utility']
		self._executables = ['xfrun']


class xfsamba (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFsamba'
		self.comment = 'XFce SAMBA control tool'
		self.keywords = ['standard', 'X11', 'XFce', 'network', 'internet', 'SAMBA', 'browse',
			'manage', 'control', 'utility']
		self._executables = ['xfsamba']


class xfterm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFterm'
		self.comment = 'XFce terminal launcher'
		self.keywords = ['standard', 'X11', 'XFce', 'terminal', 'emulate',
			'launch']
		self._executables = ['xfterm']


class xftree (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFtree'
		self.comment = 'XFce explorer-like file manager'
		self.keywords = ['standard', 'X11', 'XFce', 'explore', 'file', 'manage']
		self._executables = ['xftree']


class xfumed (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFmenu'
		self.comment = 'XFce menu editor'
		self.keywords = ['standard', 'X11', 'XFce', 'menu', 'edit', 'manage']
		self._executables = ['xfumed']


class xfwm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XFwm'
		self.comment = 'X window manager for XFce'
		self.keywords = ['XFce', 'CDE', 'clone', 'X11', 'window', 'manage']
		self._executables = ['xfwm']
		self.interactive = 0
