import os.path, string, glob
import Prophet
from Prophet import _Cacheable


class Prefixes (_Cacheable):
	"""Get as much as possible of valid prefixes"""
	def __init__ (self):
		_Cacheable.__init__ (self)
	def _Scan (self):
		# First prefixes from PATH variable
		dirs = []
		for path in string.split (os.environ['PATH'],':'):
			dirs.append (os.path.dirname (path))
		# Then go standard, well-known prefixes
		dirs = dirs + [
			'/', '/usr', '/usr/local', '/usr/X11', '/usr/X11R6', '/opt',
			'/opt/gnome', '/opt/kde', '/usr/dt', '/usr/ucb', '/usr/games',
			'/usr/local/games'
		]
		# And finally, user's home
		dirs.append (os.path.expanduser ('~'))
		prefixes = []
		for i in range (0,len (dirs) - 1):
			dir = dirs[i]
			# Omit scratched and non-existent dirs first
			if not dir or not os.path.isdir (dir):
				continue
			# Check the candidate for validity
			valid = 0
			for d in ['bin', 'sbin', '']:
				p = os.path.join (dir,d)
				if os.path.isdir (p):
					for f in os.listdir (p):
						if Prophet.Executable._isexecutable (os.path.join (p,f)):
							valid = 1
							break
					if valid:
						break
			if not valid:
				dirs[i] = None
				continue
			# Since now, dir is proved to be valid prefix
			if os.path.islink (dir):
				# Symlink takes preference over real directory, so scratch all
				# remaining candidate dirs this link points to
				for j in range (0,len (dirs) - 1):
					try:
						if dirs[j] and os.path.samefile (dir,dirs[j]):
							dirs[j] = None
					except:
						pass
				# The same is true for already remembered prefixes
				found = 0
				for j in range (0,len (prefixes) - 1):
					if os.path.samefile (dir,prefixes[j]):
						# Replace prefix with this symlink
						prefixes[j] = dir
						found = 1
						break
				if not found:
					# If no prefixes were replaced, just add the symlink as
					# yet one prefix
					prefixes.append (dir)
			else:
				# Look whether is is already present in prefixes
				try:
					prefixes.index (dir)
					# Already there
				except:
					# Not yet
					prefixes.append (dir)
			# OK, current directory is processed, scratch it and advance to
			# the next one
			dirs[i] = None
		self.prefix = prefixes
		self._success = 1


class _Extras:
	"""Class full of useful auxillary functions"""
	__wpglobs = ['*.jpg', '*.JPG', '*.jpeg', '*.JPEG', '*.png', '*.PNG', '*.tiff',
		'*.TIFF', '*.xpm'
	]
	def _WallpaperDirs (self,dirs):
		for dir in dirs:
			if dir[0] == '~':
				d = os.path.expanduser (dir)
			else:
				d = os.path.join (self.prefix,dir)
				dir = d
			if os.path.isdir (d):
				for i in self.__wpglobs:
					if len (glob.glob (os.path.join (d,i))):
						try:
							self.wallpaperdirs
						except:
							self.wallpaperdirs = []
						self.wallpaperdirs.append (dir)
						break
	def _SpecificPrefix (self,basenames):
		"Search for the specific prefix inside already known ones"
		prefixes = Prefixes ()().prefix
		for b in basenames:
			for p in prefixes:
				found = glob.glob (os.path.join (p,b + '*'))
				for f in found:
					# We're searching for directory of form `some_name....'
					# for example, `kde3' or `mozilla'
					# FIXME : provide best guess determining -- version
					# compare, for example
					# FIXME : handle possible links between the directories to
					# pick the most appropriate one
					return f
		# Nothing appropriate, return None
		return None


