import os.path, stat, glob, string, types
import Cache


# Special code convention :
# Any identifier, which represents either function name, variable, class
# method or class variable starting single underscore '_' is considered 'protected'.
# Also, any identifier starting double underscore '__' is considered 'private'.
# Either protected or private identifiers should not be used outside the
# package, especially by end user.


def __GetPkgTree (basedir, dirlist):
	"""Pick up directory list that comprises Prophet's module tree"""
	dirs = dirlist
	for f in os.listdir (basedir):
		path = os.path.join (basedir,f)
		mode = os.stat (path)[stat.ST_MODE]
		if stat.S_ISDIR (mode):
			if len (glob.glob (os.path.join (path,'__init__.py*'))):
				dirs.append (path)
			__GetPkgTree (path,dirs)
	return dirs


def __GetModules (pkgtree):
	"""Get modules present in the specified directory, with importing"""
	modules = []
	for d in pkgtree:
		m = []
		files = glob.glob (os.path.join (d,'*.py*') )
		for f in files:
			n = os.path.splitext (os.path.split (f)[1])[0]
			found = 0
			for t in m:
				if t == n:
					found = 1
					break
			if not found:
				zs = d.split ('/')
				zs = zs[zs.index ('Prophet'):]
				z = zs[0]
				for i in range (1,len (zs)):
					z = z + '.' + zs[i]
				if n == '__init__':
					exec 'import %s' % (z)
					modules.append (eval (z))
				else:
					exec 'import %s' % (z + '.' + n)
					modules.append (eval (z + '.' + n))
				m.append (n)
	return modules


def __GetCacheables (module):
	"""Get list of _Cacheable's descendants defined in specified module"""
	result = []
	for e in module.__dict__.values ():
		try:
			if issubclass (e,_Cacheable):
				if e.__name__[0] != '_':
					result.append (e)
		except TypeError:
			pass
	return result


class _Cacheable:
	"""Superclass of every entry in KB"""
	def __init__ (self):
		self._success = 0
		self.name = string.capitalize (self.__class__.__name__)
		self.keywords = []
	def __nonzero__ (self):
		return self._success
	def __call__ (self):
		s = Cache.Get (self)
		if s:
			return s
		else:
			self._Scan ()
			if self:
				Cache.Put (self)
				return self
			else:
				return None
	def AnyOf (self,list):
		for l in list:
			for k in self.keywords:
				if l.lower () == k.lower ():
					return 1
		return 0
	def AllOf (self,list):
		for l in list:
			found = 0
			for k in self.keywords:
				if l.lower () == k.lower ():
					found = 1
					break
			if not found:
				return 0
		return 1
	def NoneOf (self,list):
		for l in list:
			for k in self.keywords:
				if l.lower () == k.lower ():
					return 0
		return 1


def Scan (incmods = [],excmods = [],recursive = 1):
	result = []
	for e in GetEntries (incmods,excmods,recursive):
		r = e ()()
		if r:
			result.append (r)
	return result


def GetSubmodules (incmods = [],excmods = [],recursive = 1):
	global __modules
	result = []
	for i in incmods:
		for d in i.__dict__.values ():
			if type (d) == types.ModuleType:
				try:
					__modules.index (d) # only registered modules should be processed
					if d not in excmods:
						result.append (d)
						if recursive:
							result = result + GetSubmodules ([d],excmods,recursive)
				except ValueError:
					pass
	return result


def GetEntries (incmods = [],excmods = [],recursive = 1):
	result = []
	for i in incmods:
		for d in i.__dict__.values ():
			if type (d) == types.ClassType and issubclass (d,_Cacheable) and d.__name__[0] != '_':
				result.append (d)
	if recursive:
		submods = GetSubmodules (incmods,excmods,0) # get immediate submodules only
		if submods:
			result = result + GetEntries (submods,excmods,recursive)
	return result


__tree = __GetPkgTree (__path__[0],[])


__modules = __GetModules (__tree)


__entries = {}
for m in __modules:
	__entries[m] = __GetCacheables (m)
