#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPLv2


if(description)
{
 script_id(14291);
 script_version ("$Revision: 1.2 $");
 if ( defined_func("script_xref") ) 
	script_xref(name:"OSVDB", value:"8638");
 name["english"] = "CVSTrac timeline.c timeline_page function overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host seems to be running cvstrac, 
a web-based bug and patch-set tracking system for CVS.

This version contains a flaw related to the timeline_page() function
in timeline.c that may allow an attacker to cause a buffer overflow.
An attacker, exploiting this flaw, would be potentially able to
run exploit code on the remote machine.

***** Nessus has determined the vulnerability exists on the target
***** simply by looking at the version number(s) of CVSTrac
***** installed there. 


Solution : Update to version 1.1.4 or disable this CGI suite

Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for CVSTrac version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))
	exit(0);

if(http_is_dead(port:port))
	exit(0);

function check(url)
{
	req = http_get(item:string(url, "/cvstrac"),
 		port:port);
	r = http_keepalive_send_recv(port:port, data:req);
	if ( r == NULL ) 
		exit(0);
	if(egrep(pattern:"CVSTrac version 1\.1\.3[^0-9]", string:r))
 	{
 		security_hole(port);
		exit(0);
	}
 
}

check(url:"");
foreach dir (cgi_dirs())
{
 	check(url:dir);
}



