# This script was automatically generated from the dsa-204
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The KDE team has discovered a vulnerability in the support for various
network protocols via the KIO.  The implementation of the rlogin and telnet
protocols allows a carefully crafted URL in an HTML page, HTML email or
other KIO-enabled application to execute arbitrary commands on the
system using the victim\'s account on the vulnerable machine.
This problem has been fixed by disabling rlogin and telnet in version
2.2.2-13.woody.5 for the current stable distribution (woody).  The old
stable distribution (potato) is not affected since it doesn\'t contain
KDE.  A correction for the package in the unstable distribution (sid)
is not yet available.
We recommend that you upgrade your kdelibs3 package immediately.


Solution: http://www.debian.org/security/2002/dsa-204
Risk factor: High';

if (description) {
 script_id(15041);
 script_version('$Revision: 1.3 $');
 script_xref(name: 'DSA', value: '204');
 script_cve_id("CAN-2002-1281", "CAN-2002-1282");

 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[DSA204] DSA-204-1 kdelibs");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-204-1 kdelibs");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'kdelibs3-bin', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kdelibs3-bin is vulnerable to a flaw in Debian 3.0.\nUpgrade to kdelibs3-bin_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libarts', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarts is vulnerable to a flaw in Debian 3.0.\nUpgrade to libarts_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'kdelibs3-cups', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kdelibs3-cups is vulnerable to a flaw in Debian 3.0.\nUpgrade to kdelibs3-cups_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libkmid-alsa', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkmid-alsa is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkmid-alsa_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'kdelibs3', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kdelibs3 is vulnerable to a flaw in Debian 3.0.\nUpgrade to kdelibs3_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'kdelibs3-doc', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kdelibs3-doc is vulnerable to a flaw in Debian 3.0.\nUpgrade to kdelibs3-doc_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libarts-dev', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarts-dev is vulnerable to a flaw in Debian 3.0.\nUpgrade to libarts-dev_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libarts-alsa', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libarts-alsa is vulnerable to a flaw in Debian 3.0.\nUpgrade to libarts-alsa_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'kdelibs-dev', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kdelibs-dev is vulnerable to a flaw in Debian 3.0.\nUpgrade to kdelibs-dev_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libkmid-dev', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkmid-dev is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkmid-dev_2.2.2-13.woody.5\n');
}
if (deb_check(prefix: 'libkmid', release: '3.0', reference: '2.2.2-13.woody.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkmid is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkmid_2.2.2-13.woody.5\n');
}
if (w) { security_hole(port: 0, data: desc); }
