# This script was automatically generated from the dsa-543
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The MIT Kerberos Development Team has discovered a number of
vulnerabilities in the MIT Kerberos Version 5 software.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:
    A double-free error may allow unauthenticated remote attackers to
    execute arbitrary code on KDC or clients.
    Several double-free errors may allow authenticated attackers to
    execute arbitrary code on Kerberos application servers.
    A remotely exploitable denial of service vulnerability has been
    found in the KDC and libraries.
    Several double-free errors may allow remote attackers to execute
    arbitrary code on the server.  This does not affect the version in
    woody.

For the stable distribution (woody) these problems have been fixed in
version 1.2.4-5woody6.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.4-3.
We recommend that you upgrade your krb5 packages.


Solution: http://www.debian.org/security/2004/dsa-543
Risk factor: High';

if (description) {
 script_id(15380);
 script_version('$Revision: 1.3 $');
 script_xref(name: 'DSA', value: '543');
 script_cve_id("CAN-2004-0642", "CAN-2004-0643", "CAN-2004-0644", "CAN-2004-0772");
 script_xref(name: "CERT", value: "795632");
 script_xref(name: "CERT", value: "866472");
 script_xref(name: "CERT", value: "550464");
 script_xref(name: "CERT", value: "350792");

 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[DSA543] DSA-543-1 krb5");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-543-1 krb5");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'krb5-clients', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-clients is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-clients_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-kdc', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-kdc is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-kdc_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-telnetd', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-telnetd is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-telnetd_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-rsh-server', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-rsh-server is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-rsh-server_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-doc', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-doc is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-doc_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'libkadm55', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkadm55 is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkadm55_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'libkrb5-dev', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dev is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkrb5-dev_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-admin-server', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-admin-server is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-admin-server_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-user', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-user is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-user_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'libkrb53', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb53 is vulnerable to a flaw in Debian 3.0.\nUpgrade to libkrb53_1.2.4-5woody6\n');
}
if (deb_check(prefix: 'krb5-ftpd', release: '3.0', reference: '1.2.4-5woody6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-ftpd is vulnerable to a flaw in Debian 3.0.\nUpgrade to krb5-ftpd_1.2.4-5woody6\n');
}
if (w) { security_hole(port: 0, data: desc); }
