#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# It is released under the GNU Public Licence.
#
#

if(description)
{
 script_id(14772);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Try very hard to identify what runs on common ports";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin is a complement of find_service.nes
It tries to identify common services that were missed 
because of a network glitch

Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Identifies common services (second chance)";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO); 
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Misc.";
 family["francais"] = "Divers";

 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "find_service_3digits.nasl");
 exit(0);
}

include("misc_func.inc");
include("global_settings.inc");
if (! experimental_scripts) exit(0);

ports = make_list(4, 19, 21, 22, 23, 25, 37, 70, 79, 80, 81, 88, 98, 
109, 110, 113, 119, 143, 220, 261, 443, 448, 465, 563, 585, 593, 614, 636,
684, 873, 901, 902, 989, 990, 992, 993, 994, 995, 1080,  1085, 1109, 
1241, 1381, 2309, 2381, 2401, 2478, 2479, 2482, 2484, 2679, 3077, 3078,
3128, 3269, 3306, 3471, 5000, 5007, 5432, 7135, 8000, 8080, 8081, 
8090, 8383, 8443, 9090, 9443, 10000, 19201);

probes = make_list("", 'GET / HTTP/1.0\r\n\r\n', 'HELP\r\n\r\n');
foreach p (ports)
{
 if (debug_level > 0) display("Testing ", p, "\n");
 if (get_port_state(p) && service_is_unknown(port: p))
 {
  b = get_unknown_banner(port: p, dontfetch: 1);
  if (! b)
  {
   foreach d (probes)
   {
    s = open_sock_tcp(p);
    if (s)
    {
     if (d) send(socket: s, data: d);
     b = recv(socket: s, length: 4096);
     close(s);
    }
    if (b) break;
   }
  }
  if (b)
  {
    bl = tolower(b);

    if (b =~ "^[0-9]{3}[ -]")
    {
     if ("SMTP" >< b || "mail " >< bl)
      report_service(port: p, svc: "smtp", banner: b);
     else if ("ftp" >< bl)
      report_service(port: p, svc: "ftp", banner: b);
     else
      register_service(port: p, proto: "three_digits");
    }

    if (b[0] == '0xFF' && ord(b[1]) >= 251 && ord(b[1]) <= 254)
     report_service(port: p, svc: "telnet", banner: b);
    else if (b =~ "^HTTP/1\.[01] [0-9]{3}")
    {
     report_service(port: p, svc: "www", banner: b);
     if ("HTTP/1.1 502" >< b || egrep(string: b, pattern: "^Via:"))
      report_service(port: p, svc: "proxy", banner: b);
    }

    if (service_is_unknown(port: p))
    {
      register_service(port: p, proto: 'unknown');
      set_unknown_banner(port: p, banner: b);
    }
  }
 }
}
