#TRUSTED 2745c079c239fdfab4fd27658b1322eb5d53480cfd5d5ba6fd2a036d2bc7444920f1ffc63d16fc2d9476bfc0edacdb284d19860c20be673f9ae867f8d223c26c2ce91edf52c65dc665c542219a1bc239d6d75bcd40041a55cedb1a384e2d6ae154aaf654331fa3ab07ec57fe535670de889e06603c5f8d5b2b020311f431136a8c3fe3c3eb49dd4ff2bd46754a4cb24cabc2efb1342cd45f655ce7e529d74cf0a06b2c02b50bdc39461cda8651fd4ff81ed55956dc084ed30a3a58fb55d45355f0d68520782e7fdb6e3375d5a7e17e86be809113c777b57eb1418b70a105e79ea4ff5aeba150af508a3727ac8ecd140f8cd71cd9fce553f85af1d8fd19a78b1953d6c53702a8d7a2c70735a850d47c117e0739d83d5805f58dad4ed9cf2fae9c8d00ec6e7deb3bd113a7231f8f5b28aa332602963c3a1095c5f253c17dd49a92fe5be5170f48ac0a42720c67a7624cc987715eda070bdd41cf419cc7cf99f5ee3352d7f5e60277c9cbb19f1648839821d17d52f6f25a8c5f13c1e09450b8b901f9d32fb08bdca6a395fb6debd2075d1555c0da48645ec95a3c7e3edf90cf59b058b5719ec92a05dfcc1431e6d59415d017f0b8ddf9e11c66d5c4b758e39ddd50ba583efed649b11b88d223ec61f2aee3d5cf209015539a93b45a38b9e5b89874decfa78676037b945dcc577a20f328337cf228d23d269f8c3f4d2e9c19a589bf
#TRUSTED 14620e484c13445986bf9a84fb32cacb3ad868f28e057256f66cbb4a9ce923276cea22978933bbd132dbea8709686594265e3e7bd93976058ed0c97c91efd536d543d8ac81a52dfcafacd9d62ed9a23b358d6b3a15020a5708f82e24c6978a38f7350263fb0dcf23fa05a696f2e32983bf11e02c26293b8d6efcc2873f5fbdbe631184fbd6681980b1999e9591eb69a4eec60051c6a927f99afa53b3d092a574819f63b2606c4a026d0098620a64a575f9d546ab3aa6f5b5353c8faa014e24615d69fac4557a3fad51a415b720175a4c01f43aca74536d7b9e6884a62684a26744ebc5a66e2ee35f0c5c582de973b72ebf3e239c27d4ad4c0217c1e2e94b72a4374243e86a39672d340e53b5030428b142b2a946505a83d3303134e15ff871624260839ae74bbf6acbcf5fa324598c4d2c262c91f0771c4b46c7d1e1c9b0f5b205800a5a17396e5883516d923d4449c1f5363a657004bb46e238d37d39dde72d38023138414589c23f6bd3f1b6a83763e92eeb805346a46aa68a6780f6b6ea49ecdded03d6b77714a5e3854d8c015ce6b8d4e843034832b2c45777026f3aedafe2a10d8dbefae6fd0fe6e181664be29f0c129d2d7ef69d190413c28f43a25d1a0188f232c874dc586cfa9e325db204d300abc21fdb80ade9fe6b2ff1ebd9c5eea0ee4c09e84d7175c655ea741b87d07b63735bafda37aa1139d29649746cd19a
#
# (C) Tenable Network Security
#
# Modified by Nicolas Pouvesle to actually test for the bug
# actual test will *not* DoS dropbear
if (description) {
  script_id(14234);
  script_bugtraq_id(10803);

  if (defined_func("script_xref")) {
    script_xref(name:"OSVDB", value:"8137");
  }

  name["english"] = "Dropbear remote DSS SSH vuln";
  script_name(english:name["english"]);
 
  desc["english"] = "
The remote host is running Dropbear prior to version 0.43.  
There is a flaw in this version of Dropbear which would
enable a remote attacker to gain control of the system
from a remote location.

Solution : Upgrade to at least version 0.43 of Dropbear. 

See also : http://www.securityfocus.com/bid/10803 
 
Risk factor : High";
  script_description(english:desc["english"]);
 
  summary["english"] = "Dropbear remote DSS SSH vuln check";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) Tenable Network Security");
  family["english"] = "Gain root remotely";
  script_family(english:family["english"]);

  script_require_ports("Services/ssh", 22);
  script_dependencie("ssh_detect.nasl");
  exit(0);
}


include ('ssh_func.inc');

port = get_kb_item ("Services/ssh");
if (!port)
  port = 22;
if (!get_port_state (port))
  exit (0);

login = kb_ssh_login ();
pub = kb_ssh_publickey ();
priv = kb_ssh_privatekey ();
pass = kb_ssh_passphrase ();

if (login && pub && priv)
{
 soc = open_sock_tcp (port);
 if ( ! soc ) exit(0);
 ret = ssh_login (socket: soc, login: login, password: NULL, pub: pub, priv: priv, passphrase:pass);

 close (soc);

 if (ret == 0)
 {
	authenticated = 0;
  	socket = open_sock_tcp (port);
	if ( ! socket ) exit(0);
  	if (socket)
  	{
   		server_user = tolower (login);
   		init ();
   		server_version = ssh_exchange_identification (socket:socket);
   
   		# Like ssh_login has succeeded we don't need to test return
   		# It means SSH server is not vulnerable.
   		# However I prefer let if (!xxx) {close();exit()} ...

   		if (!server_version)
   		{
     			close (socket);
     			exit(0);
   		}
   
   		ret = ssh_kex2 (socket: socket, server_version:server_version);
   		if (ret!= 0)
   		{
     			close (socket);
     			exit(0);
   		}

   		payload = putstring (buffer:"ssh-userauth");
   		send_ssh_packet (socket: socket, payload: payload, code:raw_string (0x05));
   		payload = recv_ssh_packet (socket:socket);
   		if (ord (payload[0]) != 6)
   		{
     			close (socket);
     			exit(0);
   		}

   		payload = putstring (buffer: server_user) + putstring (buffer: "ssh-connection") + putstring (buffer:"none");
   		send_ssh_packet (socket: socket, payload: payload, code: raw_int8 (i:50));

   		payload = recv_ssh_packet (socket:socket);
   		if (ord (payload[0]) != 51)
   		{
     			close (socket);
     			exit(0);
   		}

   		support = getstring (buffer: payload, pos:1);
   		if (!ereg (string: support, pattern:"publickey"))
   		{
     			close (socket);
     			exit(0);
   		}

   		blobpub = base64decode (str:pub);
   		payload = putstring (buffer: server_user) + putstring (buffer: "ssh-connection") + putstring (buffer: "publickey") + raw_int8 (i:1);
   		to_hash = putstring (buffer: session_id) + raw_int8 (i:50);
   		typestr = getstring (buffer: blobpub, pos:0);

   		### We must not quit here because user provide a RSA key !!!
   		if (typestr >< "ssh-dss")
   		{
    			next = 4 + strlen (typestr);
    			p = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (p);
    			q = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (q);
    			g = getstring (buffer: blobpub, pos:next);
    			next = next + 4 + strlen (g);
    			pub_key = getstring (buffer: blobpub, pos:next);
    			privkey = pem_to_dsa (priv: priv, passphrase:passphrase);
    			if (!privkey)
    			{
      				close (socket);
      				exit(0);
    			}

    			payload += putstring (buffer: "ssh-dss") + putstring (buffer:blobpub);
    			to_hash += payload;
    			hash = SHA1 (to_hash);
    			signature = dsa_do_sign (p: p, q: q, g: g, pub: pub_key, priv: privkey, data:hash);
 
    			if (!signature)
    			{
      				close (socket);
      				exit(0);
    			}
           
    			signature = putstring (buffer: "ssh-dss") + crap (data: raw_string (0x00), length:44);
    			payload += putstring (buffer:signature);
    			send_ssh_packet (socket: socket, payload: payload, code: raw_int8 (i:50));
    			payload = recv_ssh_packet (socket:socket);

    			if (strlen (payload) > 1)
      				authenticated = 1;
            
    			close (socket);
           
    			if (!authenticated)
     				security_hole (port);
    			exit(0);
   		}
  	}
 }
  close (socket);
}


##### If we can not test flaw, we can test banner ######

#[root@f00dikator dropbear-0.43]# telnet localhost 22
#Trying 127.0.0.1...
#Connected to localhost.
#Escape character is '^]'.
#SSH-2.0-dropbear_0.43

banner = get_kb_item("SSH/banner/" + port );

if (! banner)
  exit(0);

  desc = "
The remote host is running Dropbear prior to version 0.43.  
There is a flaw in this version of Dropbear which would
enable a remote attacker to gain control of the system
from a remote location.

*** Nessus reports this vulnerability using only
*** information that was gathered. To really test
*** the vulnerability Nessus need an SSH account with
*** correct dsa keys.

Solution : Upgrade to at least version 0.43 of Dropbear. 

See also : http://www.securityfocus.com/bid/10803 
 
Risk factor : High";

# version 0.28 thru 0.42 are vulnerable
if (egrep(string:banner, pattern:"-dropbear_0\.(2[89]|3[0-9]|4[0-2])") )
	security_hole(port:port, data:desc);

