#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15490);
 script_bugtraq_id(11457);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : bmon < 1.2.1_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'bmon' package which is older than version
1.2.1_2.

bmon and a command-line bandwidth monitor using curses.

Older versions of this package were installed with suid root privileges. Since
this program executes commands using relative paths, an attacker would be able
to misuse this program to execute arbitrary commands as root.

Solution : http://www.vuxml.org/freebsd/938f357c-16dd-11d9-bc4a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bmon package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^bmon-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"bmon-1.2.1_2") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
