#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15518);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : ifmail <= 2.15_4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	ifmail < 2.15_4

ifmail is a FidoNet(tm) support package.

The remote version of this software allows any local user to invoke the
ifmail command with a user-supplied configuration file. Since ifmail is
setuid 'news' an attacker may exploit this flaw to execute arbitrary
commands on the remote host with the 'news' privileges.

Solution : http://www.vuxml.org/freebsd/746ca1ac-21ec-11d9-9289-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ifmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^ifmail-[0-2]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"ifmail-2.15_4") <= 0 )
	security_warning(0);
