#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12562);
 script_bugtraq_id(9369);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0031", "CAN-2004-0032");
 name["english"] = "FreeBSD Ports : libmcrypt < 2.5.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the libmcrypt package which is
older than 2.5.6.

libmcrypt is a multi-cipher cryptographic library. The remote version
does incomplete input validatin which may lead to several buffer overflows.
In addition to this, there is a memory leak issue affecting this version
of this software.

These issues can be used to cause a denial of service against a service
using this library.

Solution : http://www.vuxml.org/freebsd/c4b7badf-24ca-11d8-82e5-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libmcrypt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^libmcrypt", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"libmcrypt-2.5.6") < 0 ) 
	security_warning(0);
