#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14265);
 #script_bugtraq_id();
 script_version ("$Revision: 1.4 $");
 #script_cve_id("");
 name["english"] = "FreeBSD Ports : Popfile file download vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Popfile less than 
or equal to 0.21.1_2.

Popfile is a proxy server for POP3.  It is used to sort and 
handle email messages.  One of the benefits of Popfile is
the ability to learn and categorize 'SPAM' email.

This version of Popfile is reported as being vulnerable to a 
bug wherein certain file extensions may be permitted through
the proxy.

Solution : http://www.vuxml.org/freebsd/12c7b7ae-ec90-11d8-b913-000c41e2cdad.html
 
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the popfile package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^popfile-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"popfile-0.21.1_2") < 0 )
        security_hole(0);

