#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12628);
 script_bugtraq_id(10423);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0419");
 name["english"] = "FreeBSD Ports : xorgs-clients = 6.7.0";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of xorg-clients installed.

There is a bug in the remote version of this software which makes its listen
to xdm requests on random ports if DisplayManager.requestPort is disabled.

Solution : http://www.vuxml.org/freebsd/ff00f2ce-c54c-11d8-b708-00061bc2ad93.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^xorg-clients", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"xorg-clients-6.7.0") == 0 ) 
	security_hole(0);

