#
# (C) Tenable Network Security
#
#

if (description)
{
 script_id(15469);
 script_bugtraq_id(11371);
 script_version ("$Revision: 1.1 $");

 script_name(english:"IceWarp Web Mail Multiple Flaws");
 desc["english"] = "
The remote host is running IceWarp Web Mail - a webmail solution
available for the Microsoft Windows platform.

The remote version of this software is vulnerable to multiple 
input validation issues which may allow an attacker to compromise the
integrity of the remote host.

Solution : Upgrade to IceWarp Web Mail 5.3.0 or newer
Risk factor : High";

 script_description(english:desc["english"]);
 script_summary(english:"Check the version of IceWarp WebMail");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 4096);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:4096);

if(!get_port_state(port))exit(0);

req = http_get(item:"/", port:port);
res = http_keepalive_send_recv(port:port, data:req);
if ( res == NULL ) exit(0);
if ('Merak Email Server</A><BR>IceWarp Web Mail' >< res )
{
 if ( egrep(pattern:"IceWarp Web Mail ([0-4]\.|5\.[0-2]\.)", string:res) )
	security_hole(port);
}
