#
# IRC bot ident server detection
# Author: Brian Smith-Sweeney (bsmithsweeney@nyct.net)
# Created: 9/22/04
# Last Updated: 9/24/04
#
# See the Nessus Scripts License for details
#
if(description)
{
	script_id(14841);
	script_version ("$Revision: 1.1 $");
	name["english"] = "IRC bot ident server detection";
	desc["english"] = "
This host seems to be running an ident server, but the ident server responds 
to an empty query with a random userid.  This behavior may be indicative of an
irc bot, worm, and/or virus infection. It is very likely this system has 
been compromised.

Solution: re-install the remote system
Risk factor: High";

	summary["english"] = "Determines the presence of a malicious ident server";
	family["english"] = "Backdoors";
	script_name(english:name["english"]);
	script_description(english:desc["english"]);
	script_summary(english:summary["english"]);
	script_category(ACT_GATHER_INFO);
	script_copyright(english:"This script is Copyright (C) 2004 Brian Smith-Sweeney");
	script_family(english:family["english"]);
	script_require_ports("Services/auth", 113);
	exit(0);
}
port = get_kb_item("Services/auth");
if(! port) port = 113;
if (! get_port_state(port)) exit(0);

r='\r\n';

# Get first response
soc1 = open_sock_tcp(port);
if (! soc1) {
	exit(0);
}
if (send(socket:soc1, data:r)<= 0) exit(0);
r1 = recv_line(socket:soc1,length:1024,timeout:3);
ids1 = split(r1, sep: ':');
if ("USERID" >< ids1[1]) {
	close(soc1);
	sleep(3);
	# Get second response
	soc2 = open_sock_tcp(port);
	if (! soc2) {
		display("oops, can't open the second socket\n");
		exit(0);
	}
	send(socket:soc2, data:r);
	r2 = recv_line(socket:soc2,length:1024,timeout:3);
	ids2 = split(r2, sep: ':');
	close(soc2);
	if ("USERID" >< ids2[1]){
		if (ids1[3]==ids2[3]){
			exit(0);
		}
		security_hole(113);
		exit(0);
	}
}
else close(soc1);
