#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#

if (description) {
  script_id(12254);
  script_bugtraq_id(4909);
  script_version("$Revision: 1.5 $");

# script_cve_id("CVE-MAP-NOMATCH");
# NOTE: no CVE id assigned (gat, May 2004)

  name["english"] = "imapd arbitrary file retrieval";
  script_name(english:name["english"]);

  desc["english"] = "
The target is running an IMAP server which allows an authenticated user to
retrieve files that would be available to that user via a shell.  If
IMAP users are denied shell access, you may consider this a
vulnerability.  Additional information on the issue can be found at :

  - http://www.washington.edu/imap/IMAP-FAQs/index.html#5.1

Solution : Contact your vendor for a fix.

Risk factor : Low to High";
  script_description(english:desc["english"]);

  summary["english"] = "Checks for arbitrary file retrieval in imapd";
  script_summary(english:summary["english"]);

  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 George A. Theall");

  family["english"] = "Remote file access";
  script_family(english:family["english"]);

  script_dependencie("find_service.nes", "global_settings.nasl", "logins.nasl");
  script_require_ports("Services/imap", 143);
  script_exclude_keys("imap/false_imap");
  script_require_keys("imap/login", "imap/password");
  exit(0);
}

include("global_settings.inc");

file = "/etc/group";                    # file to grab from target.
user = get_kb_item("imap/login");
pass = get_kb_item("imap/password");
if ((user == "") || (pass == "")) {
  if (log_verbosity > 1) display("imap/login and/or imap/password are empty; skipped!\n");
  exit(1);
}

host = get_host_name();
port = get_kb_item("Services/imap");
if (!port) port = 143;
if (debug_level) display("debug: checking for IMAP Arbitrary File Retrieval vulnerability on ", host, ":", port, ".\n");

if (!get_port_state(port)) exit(0);

# Read banner.
soc = open_sock_tcp(port);
if (!soc) exit(0);
s = recv_line(socket:soc, length:1024);
if (!strlen(s)) {
  close(soc);
  exit(0);
}
if (debug_level) display("debug: S: ", s);

# Try to log in.
cnt = 0;
++cnt;
c = string("a", string(cnt), " LOGIN ", user, " ", pass, "\r\n");
if (debug_level) display("debug: C: ", c);
send(socket:soc, data:c);
while (s = recv_line(socket:soc, length:1024)) {
  if (debug_level) display("debug: S: ", s);
  m = eregmatch(pattern:string("^a", string(cnt), " (OK|BAD|NO)"), string:s, icase:TRUE);
  if (!isnull(m)) {
    resp = m[1];
    break;
  }
  resp='';
}

# If successful, try to select an arbitrary file to use as a mailbox.
if (resp && resp =~ "OK") {
  ++cnt;
  c = string("a", string(cnt), ' SELECT "', file, '"', "\r\n");
  if (debug_level) display("debug: C: ", c);
  send(socket:soc, data:c);
  while (s = recv_line(socket:soc, length:1024)) {
    if (debug_level) display("debug: S: ", s);
    m = eregmatch(pattern:string("^a", string(cnt), " (OK|BAD|NO)"), string:s, icase:TRUE);
    if (!isnull(m)) {
      resp = m[1];
      break;
    }
    resp='';
  }

  # If successful, try to read the file.
  #
  # NB: this isn't really necessary since the previous command,
  #     if successful, means we can read the file.
  if (resp && resp =~ "OK") {
    ++cnt;
    c = string("a", string(cnt), " FETCH 1 rfc822\r\n");
    if (debug_level) display("debug: C: ", c);
    send(socket:soc, data:c);
    while (s = recv_line(socket:soc, length:1024)) {
      if (debug_level) display("debug: S: ", s);
      m = eregmatch(pattern:string("^a", string(cnt), " (OK|BAD|NO)"), string:s, icase:TRUE);
      if (!isnull(m)) {
        resp = m[1];
        break;
      }
      resp='';
    }
    if (resp && resp =~ "OK") security_hole(port);
  }
}

# Logout.
++cnt;
c = string("a", string(cnt), " LOGOUT\r\n");
if (debug_level) display("debug: C: ", c);
send(socket:soc, data:c);
while (s = recv_line(socket:soc, length:1024)) {
  if (debug_level) display("debug: S: ", s);
  m = eregmatch(pattern:string("^a", string(cnt), " (OK|BAD|NO)"), string:s, icase:TRUE);
  if (!isnull(m)) {
    resp = m[1];
    break;
  }
}
close(soc);
