# This script was written by William Craig
#

if(description)
{
 script_id(12244);
 script_bugtraq_id(10301);
 script_version("$Revision: 1.2 $");

 name["english"] = " Sun Java Runtime Environment DoS ";
 script_name(english:name["english"]);

 desc["english"] = "
 The remote Windows machine is running a Java SDK or JRE version
 1.4.2_03 and prior which is vulnerable to a DoS attack.

 Solution: Upgrade to SDK and JRE 1.4.2_04
           http://java.sun.com/j2se/

 Risk factor: Medium";

 script_description(english:desc["english"]);
 summary["english"] = "Checks for Java SDK and JRE versions prior to 1.4.2_04";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2004 Netteksecure Inc. ");
 family["english"]= "Windows";
 script_family(english:family["english"]);
 script_dependencies("netbios_name_get.nasl","smb_login.nasl",
                      "smb_registry_full_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
                     "SMB/registry_full_access");
 script_require_ports(139, 445);
 exit(0);
}

# start script

include("smb_nt.inc");

port = get_kb_item("SMB/transport");

if(!port) 
	port = 139;

access = get_kb_item("SMB/registry_full_access");

if(!access)
	exit(0);



data = " The JRE Java version installed is vulnerable to a DoS attack.
          Upgrade to JRE version 1.4.2_04";

data1= " The JDK Java version installed is vulnerable to a DoS attack.
          Upgrade to JDK version 1.4.2_04";


# Is the remote machine using the JRE?
key = "SOFTWARE\JavaSoft\Java Runtime Environment";
item= "CurrentVersion";
value = registry_get_sz(key: key, item: item);

if (! value)
	exit(0);

# Is the remote machine using a version greater than or equal to 1.4?
key = "SOFTWARE\JavaSoft\Java Runtime Environment\1.4";
item = "JavaHome";

value = registry_get_sz(key: key, item: item);
if (! value)
        exit(0);



# Has the remote machine applied patch 1.4.2_04?
key =  "SOFTWARE\JavaSoft\Java Runtime Environment\1.4.2_04";
item = "JavaHome";

value = registry_get_sz(key:key, item:item);
if(! value)
{
	security_hole(port:port, data:data);
}



# Is the remote machine using the JDK?
key = "SOFTWARE\JavaSoft\Java Development Kit";
item= "CurrentVersion";
value = registry_get_sz(key: key, item: item);

if (! value)
	exit(0);


# Is the remote machine using JDK version greather than or equal to 1.4?
key = "SOFTWARE\JavaSoft\Java Development Kit\1.4";
item = "JavaHome";
value = registry_get_sz(key: key, item: item);

if (! value)
	exit(0);


# Has the remote machine applied patch 1.4.2_04? 
key = "SOFTWARE\JavaSoft\Java Development Kit\1.4.2_04";
item ="JavaHome";
value = registry_get_sz(key: key, item: item);
if(! value) 
	security_hole(port: port, data: data1);



