#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14835);
 script_version("$Revision: 1.1 $");

 name["english"] = "Symantec Norton AntiVirus Version Detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script determines the version of the remote Norton AntiVirus as
written in the registry of the remote host.

Risk Factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of the remote NAV";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}

if ( get_kb_item("SMB/samba") ) exit(0);
include("smb_nt.inc");



x_name = kb_smb_name();
if(!x_name)exit(0);

_smb_port = kb_smb_transport();
if(!_smb_port)exit(0);

if(!get_port_state(_smb_port)) exit(0);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

if(!login)login = "";
if(!pass) pass = "";

	  
soc = open_sock_tcp(_smb_port);
if(!soc) exit(0);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:x_name);
if(!r) { close(soc); exit(0); }

#
# Negociate the protocol
#
prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); exit(0); }


r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r){ close(soc); exit(0); }
uid = session_extract_uid(reply:r);

r = smb_tconx(soc:soc, name:x_name, uid:uid, share:"IPC$");
tid = tconx_extract_tid(reply:r);
if(!tid){ close(soc); exit(0); }


r = smbntcreatex(soc:soc, uid:uid, tid:tid);
if(!r){ close(soc); exit(0);}
pipe = smbntcreatex_extract_pipe(reply:r);


# Corporate Edition
key = "SOFTWARE\Symantec\Symantec AntiVirus\Install";
r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r){ close(soc); exit(0); }
handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);

key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if(key_h)
 {
  entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
  registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
# Try to find the newest entry

i_maj_max = 0;
i_min_max = 0;

 foreach version (entries)
 {
  v = split(version, sep:".", keep:0);
  if ( int(v[0]) >= i_maj_max )
  {
    if ( i_maj_max != int(v[0]) ) i_min_max = 0;
    i_maj_max = int(v[0]);
    if ( int(v[1]) >= i_min_max ) i_min_max = int(v[1]);
  }
 }
 if ( i_maj_max ) set_kb_item(name:"SymantecNortonAntiVirus/Corporate/Version", value:string(i_maj_max, ".", i_min_max));

 security_note(port:port, data:"The remote host has Symantec Norton Antivirus Coporate Edition version " + string(i_maj_max, ".", i_min_max) + " installed");
 exit(0);
}



# "Regular" edition
key = "SOFTWARE\Symantec\Norton AntiVirus";
item = "version";
key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:handle);
if ( key_h )
{
value = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:key_h);
registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
if ( value ){
	 version = registry_decode_sz(data:value);
 	 set_kb_item(name:"SymantecNortonAntiVirus/Version", value:version);
 	 security_note(port:port, data:"The remote host has Symantec Norton Antivirus version " + version + " installed");
	}
}
