#TRUSTED 122330d0ef0bdc855f8fcb953a9b3a2abc8091a734871a65afb3a9ef6df87c6316f9b22aee5f244dc6301411ddbf509e5203c67b6dffa28904952c17d216ee2228e5cd16338274504e9a63ea55df34c4af9c4a1e18e71d663a12d6a83391b553cb25498a5e261fbcda6d328ffdcdb4f1af461cec9058ba5608857e9e1286bd9a815c476fd90480188af4648f8eee48dbb968cd15cb63f2d8d51946c18d4c21256bc2f233a745c6536165af06669e1d52464fa7caef99dea16eb7b4bd956d123d8ae858c51404f3bbb1c3de4f2ee84e6e424bfacf073a73ff50ebe1fb7cac23798c044ffd8c156ca70a0784d767ef438edc898331df41a8971cd45dffbf449050d47f525ea9e65b03e11cd85f0921e14f43b7e1a926bed290abe9ba030172187989326cdae23731cbc9f3049d5621c6651a0bf0fc974a3fa30f6b7fdb6429f3f57e9c3a33557c36ba22d6e05f0287f5ef7c29e8789e97cdcdf6bf76f4729dbaf1c963a6bd29cae150101798ba5a54559f19dc8d13cf6f86e1f1ff7adc57d3e88b3c52988b40fcc42e511b1c2bf315d89bf48a49b556584218250523880984e4e9f213e060a85753536a1eeaf013fd14ec81b5ccc0a7b1f06be93fcd11addfb58438ab7e5c1bf58cdb4dda85f178c7d7cee78d074c238230ba252423cb0937c29dd731988d0a70525733df11a2fd5b9d53d0b1fa9a6b97c7cba780a71e63328359
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread") ) exit(0);



if(description)
{
 script_id(14272);
 script_version ("1.9");
 name["english"] = "Netstat 'scanner'";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs netstat on the remote machine to find open ports.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find open ports with netstat";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SCANNER);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Port scanners";
 family["francais"] = "Scanners de ports";
 script_family(english:family["english"], francais:family["francais"]);

 script_add_preference(name: "Check found ports (intrusive)", type: "checkbox", value: "no");
 script_dependencies("ping_host.nasl", "ssh_settings.nasl");
 exit(0);
}

#
include("ssh_func.inc");

buf = "";

# On the local machine, just run the command
if (islocalhost())
  buf = pread(cmd: "netstat", argv: make_list("netstat", "-a", "-n"));
else
{
# First try the netstat service, just in case
 s = open_sock_tcp(15);
 if (s)
 {
   while (r = recv(socket: s, length: 4096))
     buf += r;
   close(s);
 }
# Then try SSH if the result is not OK
 if ("LISTEN" >!< buf)
 {
 sock = ssh_login_or_reuse_connection();
 if (! sock)  exit(0);

 buf = ssh_cmd(socket:sock, cmd:"cmd /c netstat -an", timeout:60);

 if ("LISTENING" >!< buf && "0.0.0.0:0" >!< buf && "*.*" >!< buf)
 {
 buf = ssh_cmd(socket:sock, cmd:"netstat -a -n", timeout:60);
 ssh_close_connection();
 if (! buf) { display("could not send command\n"); exit(0); }
 }
}
}

# display(buf);
ip = get_host_ip();
lines = split(buf);
n = max_index(lines);
if (n == 0) n = 1; i = 0;
scanner_status(current: 0, total: n);
scanned = 0;
check = script_get_preference("Check found ports (intrusive)");
check = ("yes" >< check);	# "no" by default

identd_n = 0; identd_err = 0;

foreach line (lines)
{
  # Windows
  v = eregmatch(pattern: '^[ \t]+(TCP|UDP)[ \t]+([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+):([0-9]+)[ \t]+(0\\.0\\.0\\.0:0|\\*\\.\\*)[ \t]+', string: line, icase: 0);
  # Unix
  if (isnull(v))
   v = eregmatch(pattern: '^(tcp|udp)[46]?[ \t]+.*[ \t]+(\\*|[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)[:.]([0-9]+)[ \t]+(.*[ \t]+LISTEN|0\\.0\\.0\\.0:\\*)', string: line, icase: 1);
  if (isnull(v))
  # tcp 0 0 :::22   :::*    LISTEN
  # tcp 0 0 ::1:25  :::*    LISTEN (1 = localhost)
  v = eregmatch(pattern: '^(tcp|udp)[ \t]+.*[ \t]+(:::)([0-9]+)[ \t]+.*[ \t]+LISTEN', string: line, icase: 1);
  if (!isnull(v))
  {
    if (check && defined_func("get_source_port"))
      identd_soc = open_sock_tcp(113);
    proto = tolower(v[1]);
    addr = v[2];
    port = v[3];
    if (addr == "0.0.0.0" || addr == ip || addr == ":::" || addr == '*')
    {
      if (check && proto == "tcp")
      {
        soc = open_sock_tcp(port);
        if (soc)
        {
          scanner_add_port(proto: proto, port: port);
	  if (identd_soc)
	  {
	    req = strcat(port, ',', get_source_port(soc), '\r\n');
	    if (send(socket: identd_soc, data: req) <= 0)
	    {
	      # Let's be quick: do not reopen the socket if an error occurs
	      # Another plugin with complete the job
	      close(identd_soc);
	      identd_soc = NULL;
	      identd_err ++;
	      id = NULL;
	    }
	    else
	      id = recv_line(socket: identd_soc, length: 1024);
	    if (id)
	    {
	      ids = split(id, sep: ':');
	      if ("USERID" >< ids[1])
              {
		identd_n ++;
		set_kb_item(name: "Ident/tcp/"+port, value: ids[3]);
		security_note(port: port, 
data: 'identd reveals that this service is running as user '+ids[3]);
	      }
	    }
	  }
          close(soc);
        }
      }
      else
      scanner_add_port(proto: proto, port: port);
      # display(proto, "\t", port, "\n");
    }
    scanned ++;
  }
  scanner_status(current: i++, total: n);
}

if (identd_soc) close(identd_soc);

if (scanned)
{
 set_kb_item(name: "Host/scanned", value: TRUE);
 set_kb_item(name: "Host/udp_scanned", value: TRUE);
 if (identd_n && ! identd_err)
   set_kb_item(name: "Host/ident_scanned", value: TRUE);
}

scanner_status(current: n, total: n);
exit(0);
