#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14226);
 script_bugtraq_id(10868, 10893);
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"8353");

 script_version("$Revision: 1.4 $");
 name["english"] = "phpBB < 2.0.12";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of phpBB older than 2.0.12.

It is reported that this version of phpBB Fetch is susceptible 
to an SQL injection vulnerability. This issue is due to a failure of
the application to properly sanitize user-supplied input before using 
it in an SQL query.

The successful exploitation of this vulnerability depends on the 
implementation of the web application that includes phpBB Fetch All 
as a component.  It may or may not be possible to effectively pass 
malicious SQL statements to the underlying function. 

Successful exploitation could result in compromise of the application, 
disclosure or modification of data or may permit an attacker to exploit 
vulnerabilities in the underlying database implementation.


Solution : Upgrade to 2.0.12 or later

Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for phpBB version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

function check(dir)
{
  req = http_get(item:string(dir,"/search.php"), port:port);
  buf = http_keepalive_send_recv(port:port, data:req);
  if(buf == NULL)
	exit(0);

  if ( egrep(pattern:"www\.phpbb\.com.*_phpbb..phpBB./a. 2\.0\.([0-9]|1[01])[^0-9]", string:buf) )
  	{
	security_warning(port);
	exit(0);
	}
 return(0);
}

port = get_http_port(default:80);

if(!get_port_state(port))
	exit(0);

if(!can_host_php(port:port))
	exit(0);



foreach dir (make_list("/phpBB", cgi_dirs()))
{
 check(dir:dir);
}


