#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(13840);
 script_bugtraq_id(10738, 10753, 10754, 10883);
 if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"8164");

 script_version("$Revision: 1.6 $");
 name["english"] = "phpBB < 2.0.10";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of phpBB older than 2.0.10.

phpBB contains a flaw that allows a remote cross site scripting attack. 
This flaw exists because the application does not validate user-supplied 
input in the 'search_author' parameter.

This version is also vulnerable to a HTTP response splitting vulnerability
which permits the injection of CRLF characters in the HTTP headers.

Solution : Upgrade to 2.0.10 or later
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for phpBB version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

function check(dir)
{
  req = http_get(item:dir + "/search.php", port:port);
  buf = http_keepalive_send_recv(port:port, data:req);
  if(buf == NULL)exit(0);

  if ( egrep(pattern:"www\.phpbb\.com.*_phpbb..phpBB./a. 2\.0\.[0-9][^0-9]", string:buf) )
  	{
	security_warning(port);
	exit(0);
	}
 return(0);
}

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);



foreach dir (make_list("/phpBB", cgi_dirs()))
{
 check(dir:dir);
}
