#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# Ref: Franois SORIN <francois.sorin@security-corporation.com>
# This script is released under the GNU GPLv2


if(description)
{
 script_id(14292);
 script_bugtraq_id(8088);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0504");
 if ( defined_func("script_xref") ) 
	script_xref(name:"OSVDB", value:"2243");
 name["english"] = "PhpGroupWare multiple HTML injection vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host seems to be running PhpGroupWare, is a multi-user groupware 
suite written in PHP.

This version has been reported prone to multiple HTML injection vulnerabilities. 
The issues present themselves due to a lack of sufficient input validation 
performed on form fields used by PHPGroupWare modules. 

A malicious attacker may inject arbitrary HTML and script code using these 
form fields that may be incorporated into dynamically generated web content.

Solution : Update to version 0.9.14.005 or newer

See also: http://www.phpgroupware.org/

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for PhpGroupWare version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))
	exit(0);

if(http_is_dead(port:port))
	exit(0);

function check(url)
{
	req = http_get(item:string(url, "login.php"), port:port);
	r = http_keepalive_send_recv(port:port, data:req);
	if ( r == NULL ) 
		exit(0);

    	#We need to match this
    	#<META name="AUTHOR" content="phpGroupWare http://www.phpgroupware.org">.*phpGroupWare.*0.9.14.006
    	if ("phpGroupWare http://www.phpgroupware.org" >< r)
	{
    		if(egrep(pattern:"phpGroupWare.*0\.9\.(12|13|14\.003)", string:r))
    		{
 			security_hole(port);
			exit(0);
		}
    	}
}

check(url:"");
check(url:"/phpGroupWare/");
check(url:"/phpgw/");

foreach dir (cgi_dirs())
{
 check(url:dir);
}
