#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12635);
 script_bugtraq_id(4936, 5100);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2002-0400", "CAN-2002-0651");
 name["english"] = "RHSA-2002-119: BIND";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the BIND package installed.

All versions of BIND prior to 9.2.1 are vulnerable to at least two
critical flaws.  The first flaw allows a remote attacker to execute 
arbitrary code on the system.  The second allows a remote attacker 
to cause the BIND service to stop.

Both of the bugs can be executed by any individual with the ability to 
craft DNS responses. 

Solution : https://rhn.redhat.com/errata/RHSA-2002-119.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the BIND package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"bind-9.2.1-1.7x.2", yank:"x", prefix:"bind-", release:"RHEL2.1") ) 
	security_hole(0);


