
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12631);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0378");
	
			
 name["english"] = "RHSA-2002-120: LPRng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The LPRng print spooler daemon shipped with versions or Redhat Enterprise 
Linux 2.1 has a default configuration wherein any remote user is allowed to 
connect to the daemon.

An attacker could potentially connect to the daemon and send many print 
requests, resulting in a loss of availability to valid users of the print 
server.

Mitigating factor : Redhat Enterprise Linux 2.1 ships, by default, with an 
ipchains firewall ruleset which disallows any connections to the LPRng port.  
If the ipchains default ruleset has not been modified, this is a non-issue.

Solution : https://rhn.redhat.com/errata/RHSA-2002-120.html
Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the LPRng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"LPRng-3.7.4-28.1", prefix:"LPRng-", release:"RHEL2.1") ) 
	security_warning(0);


