#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12632);
 script_bugtraq_id(4890);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0380");
			
 name["english"] = "RHSA-2002-121: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Redhat Enterprise Linux 2.1 server is running an outdated copy of 
tcpdump.  There is a buffer overflow within the tcpdump NFS protocol parsing 
functions.  An attacker, exploiting this bug, would need to have the ability 
to craft and send NFS packets to the server.  All versions of tcpdump less 
than or equal to 3.6.2 are vulnerable.  The issue is further exacerbated by 
the fact that other applications may be using tcpdump.

Solution : https://rhn.redhat.com/errata/RHSA-2002-121.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"tcpdump-3.6.2-11.2.1AS.1", yank:"A", release:"RHEL2.1") )
	security_hole(0);

