#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12633);
 script_bugtraq_id(5406);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0384");
			
 name["english"] = "RHSA-2002-122: gaim";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Redhat Enterprise Linux 2.1 server is running a version of 
gaim prior to 0.58.  Gaim is a Linux version of the popular AIM
Instant Messenger.  Gaim is used to chat with and download files from
other users.  A buffer overflow exists in all versions of gaim prior to 0.58. 
An attacker, exploiting this overflow, would need to be able to directly 
communicate with the gaim application.  

Solution : http://rhn.redhat.com/errata/RHSA-2002-122.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"gaim-0.59-0.2.1.1", release:"RHEL2.1") ) 
	security_hole(0);


