
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12302);
 script_bugtraq_id(4937);
 script_version ("$Revision: 1.3 $");
script_cve_id("CVE-2002-0363");
	
			
 name["english"] = "RHSA-2002-123: GNU Ghostscript";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Red Hat Enterprise Linux 2.1 server is running a version
of GNU Ghostscript older than 6.53.  A bug exists within the
postscript interpretation routine which results in a buffer
overflow.  An attacker, exploiting this bug, would need to
craft a malicious postscript document and entice the end-user
to open the document with GNU Ghostscript.
 
Solution : https://rhn.redhat.com/errata/RHSA-2002-123.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Ghostscript package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"ghostscript-6.51-16.2", release:"RHEL2.1") ) 
	security_hole(0);


