#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12303);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0382");
	
 name["english"] = "RHSA-2002-124: xchat";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of XChat prior to 1.8.9.

XChat is an IRC client.  The XChat client does not properly parse the 
response to a /dns query.  An attacker, exploiting this flaw would need to 
have administrative rights on an IRC chat server.  The attacker would 
need to entice a user with a vulnerable version of XChat to connect to 
his/her IRC server.
Furthermore, the attacker would need to entice the user to execute 
the /dns query.  Once all of these prerequisites were met, the attacker 
would be able to send a specially formatted response to the /dns query 
and exploit the remote client.

Solution : https://rhn.redhat.com/errata/RHSA-2002-124.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xchat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"xchat-1.8.9-1.21as.1", yank:"as", release:"RHEL2.1") ) 
	security_warning(0);


