#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12304);
 script_bugtraq_id(4825, 4826);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0388");
			
 name["english"] = "RHSA-2002-125: mailman";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of GNU Mailman prior to 2.0.11.

GNU Mailman is a web application which allows users to read and
send email via the web frontend.  The vulnerable versions of
GNU Mailman are vulnerable to a cross-site-scripting (XSS) attack
which could allow the server to be used to attack client machines.

An attacker, exploiting this vulnerability would typically need
to entice a user of the Mailman system to click on a link to the
Mailman server.  Within the link would be scripting code which
would execute within the clients browser as if initiated from the
Mailman server.

Solution : https://rhn.redhat.com/errata/RHSA-2002-125.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mailman-2.0.11-1", release:"RHEL2.1") ) 
	security_warning(0);


