#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12305);
 script_bugtraq_id(5033);
 script_version ("$Revision: 1.3 $");
script_cve_id("CVE-2002-0392");
			
 name["english"] = "RHSA-2002-126: Apache";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Apache prior to 1.3.25.

Apache is a Web server which is used to server HTTP content over a
network.  Versions of Apache prior to 1.3.25 are vulnerable to a Denial
of Service (DoS) bug as well as a remote overflow.  The vulnerability
stems from the use of 'chunked' encoding within an HTTP request.  An 
attacker, exploiting this bug, would need to be able to craft and send
a malicious HTTP 'chunked' request to the server.  A carefully crafted
request could be used to either shut down the remote webserver or corrupt
the stack in such a way as to give the attacker remote access and rights
on the machine.

Solution : http://rhn.redhat.com/errata/RHSA-2002-126.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"apache-1.3.23-15", prefix:"apache-", release:"RHEL2.1") ) 
	security_hole(0);


