#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12306);
 script_version ("$Revision: 1.2 $");
	
			
 name["english"] = "RHSA-2002-128: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a kernel which has been known to have
several issues.  Redhat released a cumulative kernel fix which 
included a number of security fixes.  

Solution : https://rhn.redhat.com/errata/RHSA-2002-128.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.8", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_warning(0);


