#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12307);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2001-1246");
			
 name["english"] = "RHSA-2002-129: PHP";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of PHP prior to 4.1.0.

PHP is the Personal HomePage development toolkit.  A flaw within
the toolkit could allow a user to escalate privileges and gain
access to the machine.  An attacker, exploiting this bug, would
need to create a specially crafted request to the webserver.  The
request would give the attacker the ability to upload a malicious
PHP script which could then be run as the UID of the HTTP process.

Solution : https://rhn.redhat.com/errata/RHSA-2002-129.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PHP package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"php-4.1.2-2.1.4", prefix:"php-", release:"RHEL2.1") ) 
	security_hole(0);


