#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12308);
 script_bugtraq_id(5155, 5156, 5157, 5158);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2002-0713","CAN-2002-0715","CVE-2002-0714");
			
 name["english"] = "RHSA-2002-130: Squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Squid prior to 2.4 STABLE6.

This version of Squid is vulnerable to several remote overflows. 
Namely, the MSTN authentication, Gopher client, and several FTP
methods are flawed in such a way as to allow a remote attacker
to either bypass or compromise the remote host.  An attacker,
exploiting these vulnerabilities, would need to be able to send
authentication requests to the proxy, send FTP traffic to the proxy,
or operate a malicious Gopher server with the ability to entice
Squid Gopher clients to connect.

Solution : https://rhn.redhat.com/errata/RHSA-2002-130.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"squid-2.4.STABLE6-6.7.3", yank:"STABLE", prefix:"squid-", release:"RHEL2.1") ) 
	security_hole(0);


