#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12309);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0640");
	
			
 name["english"] = "RHSA-2002-131: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of OpenSSH between 2.3.1 and 3.3.

OpenSSH is an open-source SSH application which is used to allow users
to connect to the Linux server over an encrypted session.

This version of OpenSSH is vulnerable to an input validation error which
could allow a remote attacker to escalate privileges on the remote machine.
An attacker, exploiting this bug, would need to already have a local account
as well as the ability to connect to the remote OpenSSH server.

Solution : https://rhn.redhat.com/errata/RHSA-2002-131.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"openssh-3.1p1-6", prefix:"openssh-", release:"RHEL2.1") ) 
	security_hole(0);
else if ( rpm_exists(rpm:"openssh-", release:"RHEL2.1") ) 
	set_kb_item(name:"CVE-2002-0640", value:TRUE);


