#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12310);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0653");
	
			
 name["english"] = "RHSA-2002-136: mod_ssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running the Apache mod_ssl package version less than 2.8.10

mod_ssl is a module for the Apache webserver which allows for SSL and
TLS encrypted sessions.   A flaw exists which could allow a remote
attacker to format an SSL or TLS request in such a way as to overflow
the mod_ssl module and execute code as the UID of the HTTP process.

An attacker, exploiting this flaw, would need to rely on the fact that
the Apache webserver allows overrides of configuration settings on a 
'per-directory' basis.  Further, the attacker would need local access
and permissions to modify one of the directories accessed via the web.

Solution : http://rhn.redhat.com/errata/RHSA-2002-136.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_ssl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mod_ssl-2.8.7-6", prefix:"mod_ssl-", release:"RHEL2.1") ) 
	security_warning(0);


