#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12311);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0638");
			
 name["english"] = "RHSA-2002-137: util-linux";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of util-linux.  

util-linux is a package which contains a number of system utilities.  
One of these utilities, chfn, is vulnerable to a local a local race condition 
that could allow overwriting of portions of the /etc/passwd file.  This can 
lead to escalation of privileges.  An attacker, exploiting this flaw, would 
need to have local access on the machine. 	


Solution : https://rhn.redhat.com/errata/RHSA-2002-137
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util-linux package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"util-linux-2.11f-17.7.2", yank:"f", release:"RHEL2.1") ) 
	security_warning(0);


