#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12312);
 script_bugtraq_id(3024, 5834, 5835);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2001-1267","CAN-2001-1268","CAN-2001-1269","CAN-2002-0399","CAN-2002-1216");
			
 name["english"] = "RHSA-2002-138: unzip and tar";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of unzip or tar that is vulnerable to
a directory traversal bug.

Unzip and tar are used to archive or uncompress files.  There is a flaw in 
these two programs that will allow an attacker to overwrite sensitive files
when the archive contains files which are referenced as ../../../.  An attacker,
exploiting this bug, would need to be able to coerce a valid user into opening
an archive file that contained, for instance, an entry like ../../../../etc/passwd.

Solution : http://rhn.redhat.com/errata/RHSA-2002-138.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the unzip and tar package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

warn_stub = "
a directory traversal bug.

Unzip and tar are used to archive or uncompress files.  There is a flaw in
these two programs that will allow an attacker to overwrite sensitive files
when the archive contains files which are referenced as ../../../.  An attacker,
exploiting this bug, would need to be able to coerce a valid user into opening
an archive file that contained, for instance, an entry like ../../../../etc/passwd.

Solution : http://rhn.redhat.com/errata/RHSA-2002-138.html
Risk factor : High";


include("rpm.inc");

if ( rpm_check( reference:"tar-1.13.25-4.AS21.0", yank:"AS", release:"RHEL2.1") ) 
{
	mywarning = string("The remote host is running a version of tar that is vulnerable to\n",warn_stub);
	security_hole(port:0, data:mywarning);
}

if ( rpm_check( reference:"unzip-5.50-2", release:"RHEL2.1") )
{
	mywarning = string("The remote host is running a version of unzip that is vulnerable to\n",warn_stub);
	security_hole(port:0, data:mywarning);
}




