#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12313);
 script_bugtraq_id(5059, 5409);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0660","CAN-2002-0728");
			
 name["english"] = "RHSA-2002-152: libpng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of libpng prior to 1.0.14

Libpng is a package that is used for creating and manipulating Portable
Network Graphics (PNG) files.  There is a buffer over in libpng when 
processing invalid PNG files.  An attacker, exploiting this bug, would
need to be able to entice a local user into opening the graphics file
with some program that was linked to libpng.

Solution : http://rhn.redhat.com/errata/RHSA-2002-152.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"libpng-1.0.14-0.7x.3", yank:"x", prefix:"libpng-", release:"RHEL2.1") ) 
	security_warning(0);


