#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12314);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0658");
			
 name["english"] = "RHSA-2002-154: mm";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of mm prior to 1.1.4

Mm is a libary which allows programs to 'emulate' shared memory
or other interprocess communications via shared files.  There is
a bug in the program which would allow a local user to utilize mm
to overwrite any file that mm has access to.  An attacker, exploiting
this bug, would need to have local access to the machine.  The 
attacker could then use the bug to escalate his/her privileges.

Solution : http://rhn.redhat.com/errata/RHSA-2002-154.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mm package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mm-1.1.3-8", prefix:"mm-", release:"RHEL2.1") ) 
	security_hole(0);


