#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12315);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0655","CAN-2002-0656");
			
 name["english"] = "RHSA-2002-157: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of OpenSSL prior to 0.9.7b

OpenSSL is an implementation of SSL for use by either client or
server.  That is, applications like web browsers use OpenSSL as 
well as web servers.  Several bugs in OpenSSL could allow an attacker
to exploit a server or client using malformed SSL requests.  On the
server side, the flaw occurs when a client sends a malformed SSL version
2 key.  On the client side, the flaw occurs when the server sends a
malfored SSL version 3 session ID.

An, attacker, exploiting these flaws would typically need to have
network access to the webserver running OpenSSL or be able to
entice a local user to connect to their malicious SSL server.

Solution : http://rhn.redhat.com/errata/RHSA-2002-157.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"openssl-0.9.6b-24", yank:"b", prefix:"openssl-", release:"RHEL2.1") ) 
	security_hole(0);


