#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12316);
 script_bugtraq_id(5366);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0659");
			
 name["english"] = "RHSA-2002-161: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of OpenSSL prior to 0.9.6b

The version of OpenSSL is vulnerable to a remote Denial of Service
(DoS) attack which can put the program into an infinite loop.  An
attacker, exploiting this bug, would need to have access to an 
application that was utilizing OpenSSL (such as Apache Web Server).
The attacker would then send a malicious packet to the application
and cause it to fail.

Solution : http://rhn.redhat.com/errata/RHSA-2002-161.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"openssl-0.9.6b-28", yank:"b", prefix:"openssl-", release:"RHEL2.1") )
	security_hole(0);


