#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12317);
 script_bugtraq_id(5596);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0835");
			
 name["english"] = "RHSA-2002-165: PXE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of PXE which is vulnerable
to a remote Denial of Service (DoS) attack.

PXE (Pre-boot eXecution Environment) allows a workstation to boot
from a network image.  There is a flaw within this version of PXE
which would allow a remote attacker to stop the boot process by
killing the remote PXE DHCP process.  An attacker, exploiting this
flaw, would need to have access to the local network and would need
to have a rogue DHCP server which responded to PXE requests.

Solution : http://rhn.redhat.com/errata/RHSA-2002-165.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the PXE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"pxe-0.1-31.99.7.3", release:"RHEL2.1") ) 
	security_hole(0);


