#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12318);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0651","CAN-2002-0684","CVE-2002-0391");
			
 name["english"] = "RHSA-2002-167: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of glibc prior to 2.2.6.

Glibc is a package of standard libraries which are used by many
different programs on a Linux system.  There are at least 2 flaws
in this version of Glibc.  Specifically, a flaw in the XDR 
mechanism (used to decoding/encoding data structures for use in 
RPC) can lead to remote exploitation by an attacker.  A second flaw
within the DNS name resolver could also lead to remote overflow.

An attacker, exploiting these flaws, would need to either have
access to a network-based application which used the glibc XDR 
libraries (such as RPC) or have the ability to entice a glibc-
linked program to resolve a DNS name.

Solution : http://rhn.redhat.com/errata/RHSA-2002-167.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"glibc-2.2.4-29.1", prefix:"glibc-", release:"RHEL2.1") ) 
	security_hole(0);


