#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12319);
 script_bugtraq_id(4805, 4807);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0821","CAN-2002-0822","CAN-2002-0834","CVE-2002-0402","CVE-2002-0403");
			
 name["english"] = "RHSA-2002-170: ethereal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of ethereal prior to 0.9.6.

This version of ethereal is vulnerable to multiple flaws within 
it's protocol analysis modules.  An attacker can use these flaws
to execute code on the remote machine.  An attacker, exploiting
these flaws would need to know (or guess) that a remote user is
using ethereal to sniff network traffic.  Further, the attacker
would need to know that the user was sniffing one of the vulnerable
network protocols and displaying the protocols via the ethereal 
protocol dissector.  The relevant protocols are:
ISIS
BGP
SOCKS
DNS
GIOP
RSVP
AFS
LMP

Solution : http://rhn.redhat.com/errata/RHSA-2002-170.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ethereal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"ethereal-0.9.6-0.AS21.0", yank:"AS", prefix:"ethereal-", release:"RHEL2.1") ) 
	security_hole(0);


