#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12320);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0391");
			
 name["english"] = "RHSA-2002-173: Kerberos 5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an old version of krb5.

Kerberos 5 is a framework for authentication across multiple platforms.
This version of krb5 shipped with an XDR mechanism for encoding and
decoding data structures over RPC.  The XDR mechanism is flawed in such
a way as to allow a remote attacker to trigger an overflow.  An attacker,
exploiting this flaw, would need to be able to send malicious RPC packets
to the krb5 server.  In addition, the attacker would need a valid set of
credentials, as authentication would  need to take place prior to the
attack.

Solution : http://rhn.redhat.com/errata/RHSA-2002-173.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Kerberos 5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"krb5-1.2.2-14", prefix:"krb5-", release:"RHEL2.1") ) 
	security_hole(0);


