#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12321);
 script_bugtraq_id(6129);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0825","CVE-2002-0374");
			
 name["english"] = "RHSA-2002-180: nss_ldap";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of nss_ldap prior to 198.

nss_ldap is an application which will talk to an LDAP server in order
to retrieve configuration information.  This version of nss_ldap is
vulnerable to two bugs. 

The first bug is due to an overflow when nss_ldap processes a malformed
DNS name entry.  An attacker, exploiting this flaw, would need to either
own a DNS server which nss_ldap was querying or have local network access
with the ability to sniff and hijack a valid DNS session.

The second bug is due to a format string error within the logging function.
An attacker, exploiting this flaw, would need to be able to generate some
traffic against the nss_ldap server.  The overflow would occur when the 
traffic was being logged.

Solution : http://rhn.redhat.com/errata/RHSA-2002-180.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nss_ldap package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"nss_ldap-189-4", release:"RHEL2.1") ) 
	security_hole(0);


