#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12322);
 script_bugtraq_id(5298);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-0855");
			
 name["english"] = "RHSA-2002-181: mailman";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of mailman prior to 2.0.12.

Mailman is a mailing-list administrative front-end.  It allows mail 
administrators and list-users to change common configuration settings
via a Web frontend.  This version of Mailman is flawed in that it is
vulnerable to a Cross-site-scripting (XSS) attack.  An attacker,
exploiting this flaw, would need to be able to entice a valid list member
to click on a URL which contained malicious scripting.  Once the user was
successfully enticed into clicking the link, the attacker would be able
to garner their account credentials.

Solution : http://rhn.redhat.com/errata/RHSA-2002-181.html
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mailman-2.0.13-1", release:"RHEL2.1") ) 
	security_warning(0);


