#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12323);
 script_version ("$Revision: 1.2 $");
script_cve_id("CVE-2002-0989");
			
 name["english"] = "RHSA-2002-191: gaim";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Gaim prior to 0.59.1.

Gaim is an instant-messaging client that allows users in a linux
environment to chat with other users using AOL IM, ICQ, Yahoo Chat, etc.
This version of Gaim is vulnerable to a bug within the URL handler.  An
attacker, exploiting this flaw, would need to be able to entice the Gaim
user to click on a URL that was specially crafted to overflow the Gaim
client and give the attacker access.

Solution : http://rhn.redhat.com/errata/RHSA-2002-191.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"gaim-0.59.1-0.2.1", release:"RHEL2.1") ) 
	security_hole(0);


