#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12324);
 script_version ("$Revision: 1.2 $");
script_cve_id("CAN-2002-0836");
			
 name["english"] = "RHSA-2002-195: dvips";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an old and vulnerable version of dvips.

Dvips is a utility used by the printing daemon to convert DVI format
into postscript format.  There is a flaw in the way that dvips processes
user-initiated data and passes it to a system() call.  An attacker,
exploiting this flaw, would need to be able to send print requests
to the remote printing daemon.

Red Hat has published a work-around to this bug.  Namely:

rm -f /usr/share/printconf/mf_rules/mf40-tetex_filters
rm -f /usr/lib/rhs/rhs-printfilters/dvi-to-ps.fpi

Solution : http://rhn.redhat.com/errata/RHSA-2002-195.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the dvips package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"tetex-1.0.7-38.4", release:"RHEL2.1") ) 
	security_hole(0);


